<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator\Type\Mongo;

use Insight\Component\Hydrator\Exception\HydratorExceptionType;
use Insight\Component\Hydrator\Type;
use Insight\Component\Hydrator\TypeCollection;
use MongoDB\BSON\ObjectId;

if (!extension_loaded('mongodb')) {
    trigger_error('To use MongoDB types, install "ext-mongodb" first.', E_ERROR);
}

/**
 * @template-implements Type<string>
 */
final readonly class IdType implements Type
{
    public function parse(mixed $value, TypeCollection $registry): string
    {
        if (!$value instanceof ObjectId) {
            throw HydratorExceptionType::EXPECTED_MONGO_ID->raise();
        }
        return (string) $value;
    }

    public function names(): array
    {
        return ['mongo_id'];
    }
}
    