<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator\Type\Mongo;

use DateTime;
use Insight\Component\Hydrator\Exception\HydratorExceptionType;
use Insight\Component\Hydrator\Type;
use Insight\Component\Hydrator\TypeCollection;
use MongoDB\BSON\UTCDateTime;

if (!extension_loaded('mongodb')) {
    trigger_error('To use MongoDB types, install "ext-mongodb" first.', E_ERROR);
}

/**
 * @template-implements Type<DateTime>
 */
final readonly class DateTimeType implements Type
{
    public function parse(mixed $value, TypeCollection $registry): DateTime
    {
        if (!$value instanceof UTCDateTime) {
            throw HydratorExceptionType::EXPECTED_MONGO_UTC->raise();
        }
        return $value->toDateTime();
    }

    public function names(): array
    {
        return ['mongo_datetime_immutable'];
    }
}
    