<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator\Type;

use Insight\Component\Hydrator\Exception\HydratorExceptionType;
use Insight\Component\Hydrator\Type;
use Insight\Component\Hydrator\TypeCollection;

/**
 * @template-implements Type<int>
 */
final readonly class IntegerType implements Type
{
    public function parse(mixed $value, TypeCollection $registry): int
    {
        return is_int($value)
             ? $value
             : throw HydratorExceptionType::EXPECTED_INT->raise();
    }

    public function names(): array
    {
        return ['int', 'integer'];
    }
}
