<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator\Type;

use Insight\Component\Hydrator\Exception\HydratorExceptionType;
use Insight\Component\Hydrator\Type;
use Insight\Component\Hydrator\TypeCollection;

/**
 * @template-implements Type<bool>
 */
final readonly class BooleanType implements Type
{
    public function parse(mixed $value, TypeCollection $registry): bool
    {
        return is_bool($value)
             ? $value
             : throw HydratorExceptionType::EXPECTED_BOOLEAN->raise();
    }

    public function names(): array
    {
        return ['bool', 'boolean'];
    }
}
