<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator\Loader;

use Insight\Component\Hydrator\SchemaCollection;
use Insight\Component\Hydrator\SchemaConfigurator;
use SplFileInfo;

final readonly class PhpFileLoader implements FileLoader
{
    public function load(SplFileInfo $file, SchemaCollection $collection): void
    {
        $configurator = new SchemaConfigurator();

        $fn = require_once $file->getRealPath();

        $fn($configurator);

        $collection->add($configurator->build());
    }

    public function extensions(): array
    {
        return ['php'];
    }
}
