<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator\Type\Mongo;

use Insight\Component\Hydrator\Exception\HydratorExceptionType;
use Insight\Component\Hydrator\Type;
use Insight\Component\Hydrator\TypeCollection;
use MongoDB\BSON\Binary;

if (!extension_loaded('mongodb')) {
    trigger_error('To use MongoDB types, install "ext-mongodb" first.', E_ERROR);
}

/**
 * @template-implements Type<Binary>
 */
final class BinaryType implements Type
{
    public function parse(mixed $value, TypeCollection $registry): string
    {
        return $value instanceof Binary
             ? $value->getData()
             : throw HydratorExceptionType::EXPECTED_MONGO_BINARY->raise();
    }

    public function names(): array
    {
        return ['mongo_binary'];
    }
}
