<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator\Loader;

use Insight\Component\Hydrator\SchemaCollection;
use Insight\Component\Hydrator\SchemaConfigurator;
use SplFileInfo;
use Symfony\Component\Yaml\Yaml;

if (!class_exists(Yaml::class)) {
    trigger_error('To use YAML file loader, install "symfony/yaml" package first.', E_ERROR);
}

final readonly class YamlFileLoader implements FileLoader
{
    public function load(SplFileInfo $file, SchemaCollection $collection): void
    {
        $content = Yaml::parseFile($file->getRealPath());

        foreach ($content as $className => $definition) {
            $configurator = new SchemaConfigurator();
            $configurator->class($className);

            foreach ($definition['fields'] as $field) {
                $configurator->field(
                    $field['name'],
                    $field['type'],
                    $field['propertyName'] ?? null,
                    $field['nullable'] ?? false
                );
            }

            $collection->add($configurator->build());
        }
    }

    public function extensions(): array
    {
        return ['yaml', 'yml'];
    }
}
