<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator\Type;

use Insight\Component\Hydrator\Exception\HydratorExceptionType;
use Insight\Component\Hydrator\Type;
use Insight\Component\Hydrator\TypeCollection;

/**
 * @template-implements Type<float|int>
 */
final readonly class NumberType implements Type
{
    public function parse(mixed $value, TypeCollection $registry): float|int
    {
        return is_float($value) || is_int($value)
             ? $value
             : throw HydratorExceptionType::EXPECTED_NUMBER->raise();
    }

    public function names(): array
    {
        return ['number'];
    }
}
