<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator\Type;

use Insight\Component\Hydrator\Exception\HydratorExceptionType;
use Insight\Component\Hydrator\Type;
use Insight\Component\Hydrator\TypeCollection;

/**
 * @template-implements Type<string>
 */
final readonly class StringType implements Type
{
    public function parse(mixed $value, TypeCollection $registry): string
    {
        return is_string($value)
             ? $value
             : throw HydratorExceptionType::EXPECTED_STRING->raise();
    }

    public function names(): array
    {
        return ['string'];
    }
}
