<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator\Type;

use Insight\Component\Hydrator\Exception\HydratorExceptionType;
use Insight\Component\Hydrator\Type;
use Insight\Component\Hydrator\TypeCollection;

/**
 * @template-implements Type<array>
 */
final readonly class ArrayType implements Type
{
    public function parse(mixed $value, TypeCollection $registry): mixed
    {
        return is_array($value)
             ? $value
             : throw HydratorExceptionType::EXPECTED_ARRAY->raise();
    }

    public function names(): array
    {
        return ['array'];
    }
}
