<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator\Exception;

use RuntimeException;

final class HydratorException extends RuntimeException
{
    /**
     * @param list<HydratorException> $errors
     */
    public function __construct(
        public readonly string $field,
        public readonly string $type,
        public readonly  array $errors = [],
    ) {
        parent::__construct($type);
    }

    public function changeField(string $field): self
    {
        return new self(
            $field,
            $this->type,
            $this->errors,
        );
    }
}
