<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator\Symfony;

use Exception;
use Insight\Component\Hydrator\Loader\FileLoader;
use Insight\Component\Hydrator\Type;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\AbstractExtension;
use Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

final class HydratorExtension extends AbstractExtension
{
    /**
     * @throws Exception
     */
    public function loadExtension(array $config, ContainerConfigurator $container, ContainerBuilder $builder): void
    {
        $loader = new YamlFileLoader($builder, new FileLocator(__DIR__ . '/../../config/symfony'));
        $loader->load('services.yaml');

        $this->autoconfigureTypes($builder);
    }

    private function autoconfigureFileLoaders(ContainerBuilder $builder): void
    {
        $builder
            ->registerForAutoconfiguration(FileLoader::class)
            ->addTag('insight.hydrator.file_loader');
    }

    private function autoconfigureTypes(ContainerBuilder $builder): void
    {
        $builder
            ->registerForAutoconfiguration(Type::class)
            ->addTag('insight.hydrator.type');
    }
}
    