<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator;

use Insight\Component\Hydrator\Exception\HydratorConfigurationException;

final class SchemaConfigurator
{
    private string $class;

    private array $fields = [];

    public function build(): Schema
    {
        if (!isset($this->class)) {
            throw new HydratorConfigurationException('Schema must declare a class');
        }

        return new Schema($this->class, $this->fields);
    }

    public function class(string $name): self
    {
        $this->class = $name;

        return $this;
    }

    public function field(string $name, string $type, ?string $propertyName = null, bool $isNullable = false): self
    {
        $parts = explode('[]', $type);

        switch (count($parts)) {
            case 1:
                $isArray = false;
                break;

            case 2:
                $isArray = true;
                $type = $parts[0];
                break;

            default:
                throw new HydratorConfigurationException("Unsupported type: $type");
        }

        $isDocument = class_exists($type);
        $isEnum = enum_exists($type);

        $this->fields[] = new Field(
            $name,
            $propertyName ?? $name,
            $type,
            $isArray,
            $isDocument,
            $isEnum,
            $isNullable,
        );

        return $this;
    }
}
