<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator\Type;

use Insight\Component\Hydrator\Exception\HydratorExceptionType;
use Insight\Component\Hydrator\Type;
use Insight\Component\Hydrator\TypeCollection;

/**
 * @template-implements Type<string>
 */
final readonly class JsonType implements Type
{
    public function parse(mixed $value, TypeCollection $registry): array
    {
        $data = json_decode($registry->get('string')->parse($value, $registry), true);
        if (!is_array($data)) {
            throw HydratorExceptionType::EXPECTED_JSON->raise();
        }
        return $data;
    }

    public function names(): array
    {
        return ['json'];
    }
}
    