<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator\Exception;

enum HydratorExceptionType
{
    // php
    case ERROR;
    case EXPECTED_ARRAY;
    case EXPECTED_BOOLEAN;
    case EXPECTED_ENUM;
    case EXPECTED_FLOAT;
    case EXPECTED_INT;
    case EXPECTED_NUMBER;
    case EXPECTED_OBJECT;
    case EXPECTED_STRING;
    case NOT_NULLABLE;

    // ext-mongodb
    case EXPECTED_MONGO_BINARY;

    /**
     * @param list<HydratorException> $errors
     */
    public function raise(string $field = '#', array $errors = []): HydratorException
    {
        return new HydratorException($field, $this->name, $errors);
    }
}
