<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator\Type;

use Insight\Component\Hydrator\Exception\HydratorExceptionType;
use Insight\Component\Hydrator\Type;
use Insight\Component\Hydrator\TypeCollection;

/**
 * @template-implements Type<float>
 */
final readonly class FloatType implements Type
{
    public function parse(mixed $value, TypeCollection $registry): float
    {
        return is_float($value)
             ? $value
             : throw HydratorExceptionType::EXPECTED_FLOAT->raise();
    }

    public function names(): array
    {
        return ['double', 'float'];
    }
}
