<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator;

use Insight\Component\Hydrator\Exception\HydratorConfigurationException;

final class SchemaCollection
{
    /**
     * @param array<string, Schema> $storage
     */
    private function __construct(
        private array $storage = [],
    ) {
    }

    public static function empty(): self
    {
        return new self();
    }

    public static function fromSchema(Schema $schema): self
    {
        return self::fromSchemas([$schema]);
    }

    /**
     * @param Schema[] $schemas
     */
    public static function fromSchemas(array $schemas): self
    {
        $instance = new self();

        foreach ($schemas as $schema) {
            $instance->add($schema);
        }

        return $instance;
    }

    public static function merge(SchemaCollection ...$collections): SchemaCollection
    {
        $storage = [];

        foreach ($collections as $collection) {
            $storage = array_merge($storage, $collection->storage);
        }

        return new self($storage);
    }

    public function add(Schema $schema): self
    {
        $this->storage[$schema->class] = $schema;

        return $this;
    }

    public function get(object|string $class): Schema
    {
        is_string($class) || $class = $class::class;

        return $this->storage[$class] ?? throw new HydratorConfigurationException("Unsupported type: $class");
    }
}
