<?php

declare(strict_types=1);

namespace Insight\Component\Hydrator\Exception;

use RuntimeException;

final class HydratorException extends RuntimeException
{
    /**
     * @param list<HydratorException> $errors
     */
    public function __construct(
        public readonly string $field,
        public readonly string $type,
        public readonly  array $errors = [],
    ) {
        parent::__construct($type);
    }

    public function changeField(string $field): self
    {
        return new self(
            $field,
            $this->type,
            $this->errors,
        );
    }

    /**
     * @param ?callable(HydratorException): string $transformer
     *
     * @return array<string, list<string>>|string
     */
    public function flatten(?callable $transformer = null): array|string
    {
        if (count($this->errors) === 0) {
            return $transformer ? $transformer($this) : $this->getMessage();
        }

        $errors = [];

        foreach ($this->errors as $error) {
            $errors[$error->field] = $error->flatten($transformer);
        }

        return $errors;
    }
}
