<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Mongo;

use Insight\Component\EventSourcing\Attribute\EventHandler;
use Insight\Component\EventSourcing\Event;
use Insight\Component\EventSourcing\Index;
use Insight\Component\EventSourcing\IndexStore;
use Insight\Component\EventSourcing\Metadata;
use ReflectionClass;

abstract class MongoIndex implements Index
{
    /**
     * @var array<string, string[]>
     */
    private array $reactors;

    final public function when(Event $event, IndexStore $store): void
    {
        if (!isset($this->reactors)) {
            $this->reactors = [];

            $reflection = new ReflectionClass($this);

            foreach ($reflection->getMethods() as $method) {
                if (count($method->getAttributes(EventHandler::class)) === 0) {
                    continue;
                }

                // todo Validate parameters

                $name = $method->getName();
                $type = $method->getParameters()[0]->getType()->getName();

                $this->reactors[$type][] = $name;
            }
        }

        $eventInfo = Metadata::get()->aggregateEventByName($event->type(), $event->version());

        $aggregateEvent = $event->as($eventInfo->type);

        foreach ($this->reactors[$eventInfo->type] ?? [] as $reactor) {
            $this->$reactor($aggregateEvent, $store);
        }
    }
}
