<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Mongo\Document;

use DateTimeImmutable;
use Doctrine\ODM\MongoDB\Mapping\ClassMetadata;
use Doctrine\ODM\MongoDB\Mapping\MappingException;

/**
 * @final
 * @internal
 * @uses self::loadMetadata()
 */
final class System
{
    public function __construct(
        public string $documentId,
        public int $revision,
        public DateTimeImmutable $createdAt,
        public DateTimeImmutable $updatedAt,
    ) {
    }

    /**
     * @throws MappingException
     *
     * @link https://www.doctrine-project.org/projects/doctrine-mongodb-odm/en/2.9/reference/metadata-drivers.html#core-metadata-drivers
     */
    public static function loadMetadata(ClassMetadata $metadata): void
    {
        $metadata->setCollection('system');
        $metadata->markReadOnly();

        $metadata->mapField([
            'fieldName' => 'documentId',
            'type' => 'string',
            'id' => true,
            'strategy' => 'none',
        ]);
        $metadata->mapField([
            'fieldName' => 'revision',
            'name' => 'SystemRevision',
            'type' => 'integer',
        ]);
        $metadata->mapField([
            'fieldName' => 'createdAt',
            'name' => 'CreatedAt',
            'type' => 'date_immutable',
        ]);
        $metadata->mapField([
            'fieldName' => 'updatedAt',
            'name' => 'UpdatedAt',
            'type' => 'date_immutable',
        ]);
    }
}
