<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Mongo\Document;

use Doctrine\ODM\MongoDB\Mapping\ClassMetadata;
use Doctrine\ODM\MongoDB\Mapping\MappingException;

/**
 * @final
 * @internal
 * @uses self::loadMetadata()
 */
class Index
{
    public string $id;
    public string $index;

    public function __construct(string $index)
    {
        $this->index = $index;
    }

    /**
     * @throws MappingException
     *
     * @link https://www.doctrine-project.org/projects/doctrine-mongodb-odm/en/2.9/reference/metadata-drivers.html#core-metadata-drivers
     */
    public static function loadMetadata(ClassMetadata $metadata): void
    {
        $metadata->setCollection('indexes');
        $metadata->markReadOnly();

        $metadata->mapField([
            'fieldName' => 'id',
            'type' => 'string',
            'id' => true,
            'strategy' => 'auto',
        ]);
        $metadata->mapField([
            'fieldName' => 'index',
            'type' => 'string',
        ]);
        $metadata->addIndex(['index' => 1], ['unique' => true]);
    }
}
