<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Mongo\Doctrine;

use Doctrine\ODM\MongoDB\DocumentManager;
use Doctrine\Persistence\Mapping\Driver\MappingDriver;
use Doctrine\Persistence\Mapping\Driver\MappingDriverChain;
use Doctrine\Persistence\Mapping\Driver\StaticPHPDriver;

trait CustomDriver
{
    private function loadMetadataDriver(DocumentManager $documentManager): void
    {
        static $componentDriver = new StaticPHPDriver(__DIR__ . '/../Document');
        static $namespace = "Insight\Component\EventSourcing";

        $currentDriver = $documentManager->getConfiguration()->getMetadataDriverImpl();

        if ($currentDriver instanceof MappingDriverChain) {
            if (array_any($currentDriver->getDrivers(), fn($driver) => $driver === $componentDriver)) {
                return;
            }

            $currentDriver->addDriver($componentDriver, $namespace);
            return;
        }

        $chainDriver = new MappingDriverChain();
        $chainDriver->addDriver($componentDriver, $namespace);

        if ($currentDriver instanceof MappingDriver) {
            $chainDriver->addDriver($currentDriver, '');
        }

        $documentManager->getConfiguration()->setMetadataDriverImpl($chainDriver);
    }
}
