<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Exception;

use Insight\Component\EventSourcing\Projection;
use RuntimeException;
use Throwable;

final class UnrecoverableProjectionException extends RuntimeException
{
    /**
     * @var list<Throwable>
     */
    public readonly array $lastErrors;

    public function __construct(Projection $projection, Throwable ...$lastErrors)
    {
        parent::__construct(
            sprintf("Projection %s could not recover from errors.", $projection::class),
            0,
            end($lastErrors) ?: null,
        );

        $this->lastErrors = array_values($lastErrors);
    }
}
