<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing;

use DateTimeImmutable;
use Insight\Component\EventSourcing\Exception\UnserializableEventException;

interface Event
{
    /**
     * @template T of object
     *
     * @param class-string<T> $type
     *
     * @return object
     * @return T
     *
     * @throws UnserializableEventException when event data could not be decoded into object of a given type
     */
    public function as(string $type): object;

    /**
     * @return mixed[]
     */
    public function data(): array;

    public function guid(): string;

    /**
     * @return mixed[]
     */
    public function meta(): array;

    public function streamId(): string;

    public function streamPosition(): int;

    public function systemPosition(): int;

    public function time(): DateTimeImmutable;

    public function type(): string;

    public function version(): int;
}
