<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Attribute;

use Attribute;
use InvalidArgumentException;

#[Attribute(Attribute::TARGET_CLASS)]
final readonly class AggregateEvent
{
    public function __construct(public ?string $name = null, public ?int $version = null)
    {
        if (null !== $name && strlen($name) === 0) {
            throw new InvalidArgumentException('Aggregate event name must be non-empty string');
        }

        if (null !== $version && $version < 1) {
            throw new InvalidArgumentException('Aggregate event version must be greater than 0');
        }
    }
}

