<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing;

final readonly class Projector
{
    public function __construct(private EventStore $store)
    {
    }

    public function run(Projection $projection, Projection ...$projections): void
    {
        $projections[] = $projection;

        $lowestProjectionRevision = $this->findLowestRevision($projections);

        foreach ($this->store->listen(fromRevision: $lowestProjectionRevision) as $event) {
            array_walk(
                $projections,
                static fn (Projection $projection) => $projection->when($event),
            );
        }
    }

    /**
     * @param non-empty-array<Projection> $projections
     */
    private function findLowestRevision(array $projections): int
    {
        return min(array_map(
            static fn (Projection $projection) => $projection->revision(),
            $projections,
        ));
    }
}
