<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Exception;

use Exception;
use Insight\Component\EventSourcing\Event;
use Throwable;

final class UnserializableEventException extends Exception
{
    public function __construct(Event $event, string $targetType, ?Throwable $cause = null)
    {
        parent::__construct(
            sprintf("Event `%s` with id `%s` was unable to decode itself into `%s`.", $event->type(), $event->guid(), $targetType),
            0,
            $cause,
        );
    }
}
