<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Projection;

use Insight\Component\EventSourcing\Metadata;
use Insight\Component\EventSourcing\Mongo\Document\Event;

trait WithHandlers
{
    private function handle(Event $event): void
    {
        $projectionInfo = Metadata::get()->projection($this::class);

        $eventInfo = Metadata::get()->aggregateEventByName($event->type(), $event->version());

        if (empty($handlers = $projectionInfo->handlersByType($eventInfo->type))) {
            return;
        }

        $aggregateEvent = $event->as($eventInfo->type);

        foreach ($handlers as $handler) {
            $this->$handler($aggregateEvent, $event);
        }
    }
}
