<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Mongo\Value;

use DateTimeImmutable;
use DateTimeInterface;
use DateTimeZone;

final readonly class Time
{
    private function __construct(public DateTimeImmutable $dateTime)
    {
    }

    public static function fromDateTime(DateTimeInterface $dateTime): self
    {
        return new self(
            self::toUTC(
                DateTimeImmutable::createFromInterface($dateTime),
            ),
        );
    }

    public static function fromMilliseconds(int $time): self
    {
        $timestamp = $time / 1000;

        return new self(
            new DateTimeImmutable("@$timestamp"),
        );
    }

    public static function now(): self
    {
        return new self(
            self::toUTC(new DateTimeImmutable()),
        );
    }

    public function milliseconds(): int
    {
        return (int) $this->dateTime->format('Uv');
    }

    public function timestamp(): int
    {
        return $this->dateTime->getTimestamp();
    }

    private static function toUTC(DateTimeImmutable $dateTime): DateTimeImmutable
    {
        static $timezone = new DateTimeZone('UTC');

        // @phpstan-ignore argument.type
        return $dateTime->setTimezone($timezone);
    }
}
