<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Mongo\Exception;

use Composer\InstalledVersions;
use LogicException;

final class DependencyException extends LogicException
{
    public function __construct()
    {
        parent::__construct('To use MongoDB event sourcing component, install "doctrine/mongodb-odm" package first.');
    }

    public static function check(): void
    {
        static $checked = InstalledVersions::isInstalled('doctrine/mongodb-odm');

        $checked || throw new self();
    }
}
