<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Metadata\Info;

use Insight\Component\EventSourcing\Attribute\AggregateEvent;
use InvalidArgumentException;
use ReflectionClass;

final readonly class AggregateEventInfo
{
    private function __construct(
        public string $type,
        public string $name,
        public int $version,
    ) {
    }

    public static function parse(string $type): self
    {
        if (!class_exists($type)) {
            throw new InvalidArgumentException();
        }

        $reflection = new ReflectionClass($type);
        $attributes = $reflection->getAttributes(AggregateEvent::class);

        switch (count($attributes)) {
            case 0:
                throw new InvalidArgumentException('');
            case 1:
                break;
            default:
                throw new InvalidArgumentException("Multiple aggregate event declarations for class $type");
        }

        /** @var AggregateEvent $attribute */
        $attribute = $attributes[0]->newInstance();

        return new self(
            $type,
            $attribute->name ?? $reflection->getShortName(),
            $attribute->version ?? 1,
        );
    }
}
