<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing;

interface IndexStore
{
    /**
     * Returns TRUE if index is set.
     */
    public function exists(string $index): bool;

    /**
     * Sets new index.
     *
     * This method SHOULD pass silently if index already exists, as it should be up to the event store to handle that case.
     *
     * @param list<string> $tags
     */
    public function set(string $index, array $tags = []): void;

    /**
     * Returns a list of indexes that match ALL given tags.
     *
     * @param list<string> $tags
     *
     * @return list<string>
     */
    public function tagged(array $tags): array;

    /**
     * Removes (releases) an index.
     */
    public function unset(string $index): void;

    /**
     * Removes (releases) all indexes that are tagged with given tags.
     *
     * @param list<string> $tags
     */
    public function unsetTagged(array $tags): void;
}
