<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Exception;

use Insight\Component\EventSourcing\Event;
use RuntimeException;

/**
 * Thrown whenever an event is not recognized by the application.
 */
final class UnknownEventException extends RuntimeException
{
    public function __construct(Event $event)
    {
        parent::__construct(
            sprintf("Unknown event type `%s` (id: `%s`).", $event->type(), $event->guid()),
        );
    }
}
