<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Attribute;

use Attribute;
use InvalidArgumentException;

#[Attribute(Attribute::TARGET_CLASS)]
final readonly class AggregateName
{
    public function __construct(public string $value)
    {
        if (strlen($value) === 0) {
            throw new InvalidArgumentException('Aggregate name must be a non-empty string.');
        }
    }
}
