<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing;

interface Projection extends EventReactor
{
    /**
     * Resets projection state, effectively clearing all the data so that it can be replayed.
     */
    public function reset(): void;

    /**
     * Returns current state revision.
     */
    public function revision(): int;

    /**
     * Synchronizes this projection immediately with the event store.
     */
    public function sync(EventStore $store): void;
}
