<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Mongo;

use Doctrine\ODM\MongoDB\DocumentManager;
use Doctrine\ODM\MongoDB\MongoDBException;
use Insight\Component\EventSourcing\IndexStore;
use Insight\Component\EventSourcing\Mongo\Document\Index;
use Throwable;

final readonly class MongoIndexStore implements IndexStore
{
    public function __construct(private DocumentManager $documentManager)
    {
    }

    /**
     * @throws MongoDBException
     */
    public function exists(string $index): bool
    {
        return $this->documentManager->getDocumentCollection(Index::class)->countDocuments(['name' => $index]) > 0;
    }

    /**
     * @throws Throwable
     */
    public function set(string $index, string ...$indexes): void
    {
        $indexes[] = $index;

        foreach ($indexes as $i) {
            $this->documentManager->persist(new Index($i));
        }
    }

    /**
     */
    public function unset(string $index, string ...$indexes): void
    {
        $indexes[] = $index;

        foreach ($indexes as $i) {
            $this->documentManager->remove(
                $this->documentManager->getReference(Index::class, $i),
            );
        }
    }
}
