<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing;

interface IndexStore
{
    /**
     * Returns TRUE if index is set.
     */
    public function exists(string $index): bool;

    /**
     * Sets new index.
     *
     * This method SHOULD pass silently if index already exists as it should be up to the event store to handle that case.
     */
    public function set(string $index, string ...$indexes): void;

    /**
     * Removes (releases) an index.
     */
    public function unset(string $index, string ...$indexes): void;
}
