<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing;

use Insight\Component\EventSourcing\Projection\WithHandlers;

abstract class Index
{
    use WithHandlers;

    /**
     */
    final public function when(Event $event, IndexStore $store): void
    {
        $this->handle(
            $event,
            function (string $handler, Event $event, object $aggregateEvent) use ($store) {
                $this->$handler($aggregateEvent, $store);
            },
        );
    }
}
