<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Exception;

use Insight\Component\EventSourcing\Event;
use RuntimeException;
use Throwable;

/**
 * Thrown whenever an event payload cannot be deserialized into a specific aggregate event instance.
 */
final class UnserializableEventException extends RuntimeException
{
    public function __construct(Event $event, string $targetType, ?Throwable $cause = null)
    {
        parent::__construct(
            sprintf("Event `%s` with id `%s` was unable to decode itself into `%s`.", $event->type(), $event->guid(), $targetType),
            0,
            $cause,
        );
    }
}
