<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Exception;

use Insight\Component\EventSourcing\Event;
use RuntimeException;

/**
 * Thrown whenever attempted to use an unknown index.
 */
final class UnknownIndexException extends RuntimeException
{
    public function __construct(string $class)
    {
        parent::__construct(
            sprintf("Unknown index `%s`.", $class),
        );
    }
}
