<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing;

use Insight\Component\EventSourcing\Projection\WithHandlers;
use RuntimeException;

abstract class Index
{
    use WithHandlers;

    private IndexStore $indexStore;

    /**
     */
    final public function when(Event $event): void
    {
        $store = $this->getIndexStore();

        $this->handle(
            $event,
            function (string $handler, Event $event, object $aggregateEvent) use ($store) {
                $this->$handler($aggregateEvent, $event, $store);
            },
        );
    }

    /**
     */
    final public function withIndexStore(IndexStore $store): self
    {
        $index = clone $this;

        $index->indexStore = $store;

        return $index;
    }

    /**
     */
    final protected function getIndexStore(): IndexStore
    {
        return $this->indexStore ?? throw new RuntimeException('Index store is not available.');
    }
}
