<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Exception;

use RuntimeException;

final class UnexpectedRevisionException extends RuntimeException
{
    public function __construct(string $streamId, int $revisionExpected, int $revisionActual)
    {
        parent::__construct(
            "Stream revision for stream `$streamId` was expected to be at position $revisionExpected but it is at position $revisionActual"
        );
    }
}
