<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing;

use LogicException;

abstract class EventSourceAggregate
{
    /**
     * @var array{object, mixed[]}[]
     */
    private(set) array $aggregateChanges = [];

    private(set) bool $aggregateClosed = false;

    private(set) string $aggregateId;

    private(set) int $aggregateVersion = 0;

    final protected function __construct(string $aggregateId)
    {
        $this->aggregateId = $aggregateId;
    }

    final protected function markAggregateAsClosed(): void
    {
        $this->aggregateClosed = true;
    }

    /**
     * @param mixed[] $meta
     */
    final protected function record(object $aggregateEvent, array $meta = []): self
    {
        $this->apply($aggregateEvent);

        $this->aggregateChanges[] = [$aggregateEvent, $meta];

        return $this;
    }

    private function apply(object $aggregateEvent): void
    {
        if ($this->aggregateClosed) {
            throw new LogicException('Cannot operate on a closed aggregate.');
        }

        $info = Metadata::get()->aggregate(static::class);

        foreach ($info->handlersByEventType($aggregateEvent::class) as $handler) {
            $this->$handler($aggregateEvent);
        }
    }
}
