<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Mongo\Value;

use Symfony\Component\Uid\Uuid;
use Symfony\Component\Uid\UuidV4;

final readonly class Guid
{
    private function __construct(private string $value)
    {
    }

    public static function from(string $value): self
    {
        return new self(
            UuidV4::fromString($value)->toString(),
        );
    }

    public static function generate(): self
    {
        return new self(
            Uuid::v4()->toString(),
        );
    }

    public function toString(): string
    {
        return $this->value;
    }
}
