<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Mongo\Document;

use Doctrine\ODM\MongoDB\Mapping\ClassMetadata;
use Doctrine\ODM\MongoDB\Mapping\MappingException;

/**
 * @template TDocument
 *
 * @final
 * @internal
 * @uses self::loadMetadata()
 */
class Position
{
    /**
     * @param class-string<TDocument> $class
     */
    public function __construct(
        public string $class,
        public int $revision,
    ) {
    }

    /**
     * @throws MappingException
     *
     * @link https://www.doctrine-project.org/projects/doctrine-mongodb-odm/en/2.9/reference/metadata-drivers.html#core-metadata-drivers
     */
    public static function loadMetadata(ClassMetadata $metadata): void
    {
        $metadata->setCollection('doctrine_odm_ledger');

        $metadata->mapField([
            'fieldName' => 'class',
            'type' => 'string',
            'id' => true,
            'strategy' => 'none',
        ]);
        $metadata->mapField([
            'fieldName' => 'revision',
            'type' => 'integer',
        ]);
    }
}
