<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Mongo\Document;

use Doctrine\ODM\MongoDB\Mapping\ClassMetadata;
use Doctrine\ODM\MongoDB\Mapping\MappingException;

/**
 * @final
 * @internal
 * @uses self::loadMetadata()
 */
class Index
{
    public string $id;

    /**
     */
    public function __construct(
        public string $namespace,
        public string $lookupId,
        public string $key,
        public string $value,
    ) {
    }

    /**
     * @throws MappingException
     *
     * @link https://www.doctrine-project.org/projects/doctrine-mongodb-odm/en/2.9/reference/metadata-drivers.html#core-metadata-drivers
     */
    public static function loadMetadata(ClassMetadata $metadata): void
    {
        $metadata->setCollection('indexes');
        $metadata->markReadOnly();

        $metadata->mapField([
            'fieldName' => 'id',
            'type' => 'string',
            'id' => true,
            'strategy' => 'auto',
        ]);
        $metadata->mapField([
            'fieldName' => 'namespace',
            'name' => 'n',
            'type' => 'string',
        ]);
        $metadata->mapField([
            'fieldName' => 'lookupId',
            'name' => 'l',
            'type' => 'string',
        ]);
        $metadata->mapField([
            'fieldName' => 'key',
            'name' => 'k',
            'type' => 'string',
        ]);
        $metadata->mapField([
            'fieldName' => 'value',
            'name' => 'v',
            'type' => 'string',
        ]);

        $metadata->addIndex(
            ['n' => 1, 'l' => 1, 'k' => 1, 'v' => 1],
            ['unique' => true],
        );
    }
}
