<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing;

use Exception;

interface IndexStore
{
    /**
     * Returns all lookup ids matching given index.
     *
     * @return list<string>
     */
    public function lookup(string $namespace, string $key, string $value): array;

    /**
     * Returns one lookup id matching given index or NULL if such does not exist.
     *
     * @throws Exception When there is more than one matching lookup id.
     */
    public function lookupOne(string $namespace, string $key, string $value): ?string;

    /**
     * Removes all indexes from the store.
     */
    public function purge(): void;

    /**
     * Sets new index.
     *
     * This method SHOULD pass silently if index already exists, as it should be up to the event store to handle that case.
     */
    public function set(string $lookupId, string $namespace, string $key, string $value): void;

    /**
     * Removes (releases) an index.
     */
    public function unset(string $lookupId, string $namespace, string $key, string $value): void;

    /**
     * Removes (releases) all indexes for a given lookup.
     */
    public function unsetLookup(string $lookupId): void;
}
