<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Projection;

use Insight\Component\EventSourcing\Event;
use Insight\Component\EventSourcing\EventHandlersList;
use Insight\Component\EventSourcing\Exception\UnknownEventException;
use Insight\Component\EventSourcing\Metadata;

trait WithHandlers
{
    /**
     * This method resolves the event handlers within the class and invokes them one by one.
     *
     * @param ?callable(): void $invoke This function can be used to customize handler's call.
     */
    private function handle(Event $event, ?callable $invoke = null): void
    {
        $invoke ??= function(string $handler, Event $event, object $aggregateEvent) {
            $this->$handler($aggregateEvent, $event);
        };

        $eventInfo = Metadata::get()->aggregateEventByName($event->type(), $event->version());

        if ($eventInfo === null) {
            throw new UnknownEventException($event);
        }

        $aggregateEvent = $event->as($eventInfo->type);

        $handlers = EventHandlersList::fromClass(static::class);

        foreach ($handlers->forAggregateEvent($aggregateEvent) as $handler) {
            $invoke($handler, $event, $aggregateEvent);
        }
    }
}
