<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing\Mongo\Document;

use Doctrine\ODM\MongoDB\Mapping\ClassMetadata;
use Doctrine\ODM\MongoDB\Mapping\MappingException;

/**
 * @final
 * @internal
 * @uses self::loadMetadata()
 */
class Index
{
    public string $id;

    /**
     * @param list<string> $tags
     */
    public function __construct(public string $index, public array $tags)
    {
    }

    /**
     * @throws MappingException
     *
     * @link https://www.doctrine-project.org/projects/doctrine-mongodb-odm/en/2.9/reference/metadata-drivers.html#core-metadata-drivers
     */
    public static function loadMetadata(ClassMetadata $metadata): void
    {
        $metadata->setCollection('indexes');
        $metadata->markReadOnly();

        $metadata->mapField([
            'fieldName' => 'id',
            'type' => 'string',
            'id' => true,
            'strategy' => 'auto',
        ]);
        $metadata->mapField([
            'fieldName' => 'index',
            'type' => 'string',
        ]);
        $metadata->mapField([
            'fieldName' => 'tags',
            'type' => 'collection',
        ]);
        $metadata->addIndex(['index' => 1], ['unique' => true]);
    }
}
