<?php

declare(strict_types=1);

namespace Insight\Component\EventSourcing;

use Iterator;

interface Listenable
{
    /**
     * Returns an iterator that continuously iterates over events.
     *
     * It is possible to choose from which revision iterator is supposed to start iterating forward.
     *
     * @return Iterator<int, Event>
     */
    public function listen(?int $fromRevision = null): Iterator;
}
